#version 330 core

#define DO_BLIT

#ifdef DO_BLIT
uniform sampler2D light_accumulation;
#else
//#define VIEW_DIFFUSE
//#define VIEW_SPECULAR
//#define VIEW_NORMALS
//#define VIEW_DEPTH
//#define VIEW_AO
//#define VIEW_GI
//#define VIEW_LIGHT_STREAKS
#define VIEW_SHADOW_BUFFER_1
//#define VIEW_SHADOW_BUFFER_2
uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform sampler2D ssao_buffer;
uniform sampler2D lightstreaks;
uniform sampler2D shadow_buffer_1;
uniform sampler2D shadow_buffer_2;
#endif // !DO_BLIT


in vec2 uv;

layout (location = 0) out vec4 frag_color;

void main()
{
#ifdef DO_BLIT
	vec4 la = texture(light_accumulation, uv);
	frag_color = vec4(la.rgb, 1.0);
#else

#ifdef VIEW_DIFFUSE
	vec4 ds = texture(diffuse_specular, uv);
	frag_color = vec4(ds.rgb, 1.0);
#endif

#ifdef VIEW_SPECULAR
	vec4 ds = texture(diffuse_specular, uv);
	frag_color = vec4(ds.aaa, 1.0);
#endif

#ifdef VIEW_NORMALS
	vec3 nd = normalize(texture(normal_depth, uv).rgb)*0.5 + vec3(0.5);
	frag_color = vec4(nd.rgb, 1.0);
#endif

#ifdef VIEW_DEPTH
	vec4 nd = texture(normal_depth, uv);
	frag_color = vec4(nd.aaa, 1.0);
#endif

#ifdef VIEW_AO
	vec4 sb = texture(ssao_buffer, uv2);
	frag_color = vec4(sb.aaaa, 1.0);
#endif

#ifdef VIEW_GI
	vec4 sb = texture(ssao_buffer, uv2);
	frag_color = vec4(sb.rgb, 1.0);
#endif

#ifdef VIEW_LIGHT_STREAKS
	vec4 ls = texture(lightstreaks, uv);
	frag_color = vec4(ls.rgb, 1.0);
#endif

#ifdef VIEW_SHADOW_BUFFER_1
	vec4 sb = texture(shadow_buffer_1, uv);
	frag_color = sb;
#endif

#ifdef VIEW_SHADOW_BUFFER_2
	vec4 sb = texture(shadow_buffer_2, uv);
	frag_color = sb;
#endif

#endif // !DO_BLIT
}
